// VDCGenDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VDCGen.h"
#include "VDCGenDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVDCGenDlg dialog

CVDCGenDlg::CVDCGenDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVDCGenDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVDCGenDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVDCGenDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVDCGenDlg)
	DDX_Control(pDX, IDC_STOP_VDC, m_Stop);
	DDX_Control(pDX, IDC_START_VDC, m_Start);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVDCGenDlg, CDialog)
	//{{AFX_MSG_MAP(CVDCGenDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN_DRIVER, OnOpenDriver)
	ON_BN_CLICKED(IDC_START_VDC, OnStartVdc)
	ON_BN_CLICKED(IDC_STOP_VDC, OnStopVdc)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVDCGenDlg message handlers

BOOL CVDCGenDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVDCGenDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVDCGenDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVDCGenDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVDCGenDlg::OnOpenDriver() 
{
/*
  This example was written in MSVC++ 6.0 Standard Edition
  in Win2K SP1 with 3140-850A02 DriverLINX driver for KPCI-3140.

  This example shows how to generate a variable duty pulse train from
  one counter of the KPCI-3140.  Look for output at pin 3 of STP-3140 or
  pin 66 of STP-68.

*/

	   // Open the driver and Initialize the hardware
m_pSR=NULL;
m_driverInstance=NULL;
// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3140"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=0; //set the device number (DriverLINX Config Panel setting)
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_Start.EnableWindow(TRUE);  // enable the Sample button
UpdateData(FALSE);
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box

}

// set focus back to our dialog
CWnd::SetActiveWindow();		
}

void CVDCGenDlg::OnStartVdc() 
{
	// TODO: Add your control notification handler code here
/*
               onCount
 _____________         _____________        _____________
              |       |             |      |
		      |       |             |      | 
		       ---=----              -------

  OUTPUT from a C/T of KPCI-3140 will normally be logic 1, so if your
  application can be designed to use active lo pulses, every thing will be
  easier to implement.  Allow the output to be normally high and go low for the
  programmed amount of time (onCount).

  Alternately, you can generate active hi pulses, but the output will not go to
  the low state until the task is started.  As soon as task is stopped, the output
  will go back to it's default state of hi.  Best to add an inverter or other hardware
  solution if need the output to normally be low.

*/
// setup the DriverLINX task
m_pSR->operation=START;  // start operation
m_pSR->subsystem=CT;     // using CT subsystem
m_pSR->mode=POLLED;      // no timing info required.....POLLED mode
m_pSR->start.typeEvent=COMMAND;   // start when we call DriverLINX function
m_pSR->timing.typeEvent=RATEEVENT;  // speed of the task will be specified
m_pSR->stop.typeEvent=NULLEVENT;  // stop type
m_pSR->timing.u.rateEvent.channel=0;   // use channel 0 of CT subsystem
m_pSR->timing.u.rateEvent.mode=VDCGEN;  // generate VDC Wave
m_pSR->timing.u.rateEvent.pulses=0;     // not used
m_pSR->timing.u.rateEvent.pulses |= OUTPUTLOTOGGLED;  // mostly high goes low for onCount
//m_pSR->timing.u.rateEvent.pulses |= OUTPUTLOTOGGLED;  // mostly low, goes hi for onCount
m_pSR->timing.u.rateEvent.clock=INTERNAL1;  // the only internal timebase, 40MHz
m_pSR->timing.u.rateEvent.pulses |= OUTPUTLOTOGGLED;
//  period = total time for one cycle; can not exceed 65535 tics
// onCount = time the pulse will be active lo for OUTPUTLOTOGGLED
// onCount is a portion of the total period.
// hi duration = period - onCount
m_pSR->timing.u.rateEvent.period= 65525;  
m_pSR->timing.u.rateEvent.onCount=5000;  // duration it will be active LO
//  period and onCount are expressed in the number of tics of the
// selected timebase which is 40MHz for the internal one of the KPCI-3140.
// if 65K counts of 40MHz is too fast, use another channel in SquareWave mode
// to generate a slower timebase signal.
m_pSR->timing.u.rateEvent.gate=NOCONNECT;  // gating not used in this example
if (DriverLINX(m_pSR) == NoErr)  // start the task by calling DriverLINX function
{
	// success
m_Stop.EnableWindow(TRUE);  // enable the Stop button
m_Start.EnableWindow(FALSE);  // disable the Start button
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box
}	
}

void CVDCGenDlg::OnStopVdc() 
{
	// TODO: Add your control notification handler code here
/*
  if we do a STOP operation on a task that does not exist, an error will result.
  this app does not do any error checking for this condition.
*/
m_pSR->operation=STOP;	
DriverLINX(m_pSR);
//  would be "active task not found" error if no active task existed
//  But it does not kill us.
m_Stop.EnableWindow(FALSE);  // disable the Stop button
m_Start.EnableWindow(TRUE);  // enable the Start button	
}

void CVDCGenDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	// code to clean up after DriverLINX
if (m_driverInstance != NULL)
{
   CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
   m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
}
if (m_pSR != NULL)
{

   delete(m_pSR); //de-allocate the memory used by the service request
   m_pSR=NULL;
}
	CDialog::OnClose();
}

void CVDCGenDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
/*
// the code below could be used instead of the messagebox operation above

char errString[100];
DWORD size=50;
int errNumber;
errNumber = getErrCode(SR->result);
// errNumber corresponds to DriverLINX documentation
ReturnMessageString(SR->hWnd,SR->result,errString,size);
// errString corresponds to DriverLINX documentation
m_errMsg.Format("%s",errString);  // would need to add a static text called m_errMsg to dialog
UpdateData(FALSE);  // update the dialog
*/

	return;
}
